//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "uspl.h"
#include "audioc.h"
//---------------------------------------------------------------------------
AudioC::AudioC(char *fname)
{
   // initialize
   init();

   // attempt to load file
   if (ReadFile(fname)==0) this->~AudioC();
}

//copy constructor
AudioC::AudioC(AudioC &orig)
{
   init();
   MaxBytes=orig.MaxBytes;
   NumSamps=orig.NumSamps;
   // copy header
   Hdr=orig.Hdr;
   Buf=(char*) malloc(MaxBytes);
   // copy data
   if (Buf!=NULL) memcpy(Buf,orig.Buf,MaxBytes);
}
AudioC::~AudioC()
{
   if (Buf!=NULL) free(Buf);
}

void AudioC::init()
{
   NumSamps=0;
   MaxBytes=0;
   Buf=NULL;

   Hdr.Channels=2;
   Hdr.SampleRate=22050;
   Hdr.BitsPerSample=16;
   Hdr.BlockAlign=(short) (Hdr.Channels*Hdr.BitsPerSample / 8);
   Hdr.BytesPerSec=Hdr.SampleRate*Hdr.BlockAlign;
   Hdr.DataLength=NumSamps*Hdr.BlockAlign;

}
unsigned long AudioC::SetSampleRate(unsigned long SampleRate)
{
   Hdr.SampleRate=SampleRate;
   return(SampleRate);
}

char * AudioC::SetBuffer(char *NewBuf,unsigned long NewNumBytes)
{
char *tbuf;

  tbuf=Buf;
  // see if we have enough room
  if (NewNumBytes>MaxBytes)
  {
     Buf=(char*) realloc(Buf,NewNumBytes);
     if (Buf==NULL)
     {
        Buf=tbuf;
        return NULL;
    }
    else MaxBytes=NewNumBytes;
  }

  memcpy(Buf,NewBuf,NewNumBytes);
  return (Buf);
}

short AudioC::SetNumChan(short NumChan)
{
   if (NumChan!=1 && NumChan!=2) return(0);
   Hdr.Channels=NumChan;
   return(Hdr.Channels);
}

short AudioC::SetBitsPerSamp(short BitsPerSamp)
{
   if (BitsPerSamp!=8 && BitsPerSamp!=16) return(0);
   Hdr.BitsPerSample=BitsPerSamp;

   // make changes to lengths
   Hdr.BlockAlign=(short) (Hdr.Channels*Hdr.BitsPerSample / 8);
   Hdr.BytesPerSec=Hdr.SampleRate*Hdr.BlockAlign;
   Hdr.DataLength=NumSamps*Hdr.BlockAlign;

   return(Hdr.BitsPerSample);
}

unsigned long AudioC::SetNumSamps(unsigned long Num)
{
char *tbuf;

   if (Num*Hdr.BlockAlign>MaxBytes)
   {
      tbuf=Buf;
      Buf=(char *) realloc(Buf,Num*Hdr.BlockAlign);
  }
  
  // did we get a good buffer?
  if (Buf==NULL)
  {
     Buf=tbuf;
     return(0);
  }
   NumSamps=Num;
   MaxBytes=Num*Hdr.BlockAlign;
   // make changes to lengths
   Hdr.BlockAlign=(short) (Hdr.Channels*Hdr.BitsPerSample / 8);
   Hdr.BytesPerSec=Hdr.SampleRate*Hdr.BlockAlign;
   Hdr.DataLength=NumSamps*Hdr.BlockAlign;
   return (NumSamps);
}


long AudioC::WriteFile(char *fname)
{
FILE *fptr;
long status=1;

  // Some Basic Error Checking
  if (Hdr.Channels!=1 && Hdr.Channels!=2) return(0);
  if (Hdr.BitsPerSample!=8 && Hdr.BitsPerSample!=16) return(0);
  
  strncpy(Hdr.RIFF,"RIFF",4);
  strncpy(Hdr.FormatType,"WAVE",4);
  strncpy(Hdr.ChunkType,"fmt ",4);
  strncpy(Hdr.DATA,"data",4);
  Hdr.FormatTag=1;     // PCM only
  Hdr.ChunkLength=16;  // hard coded
  Hdr.BlockAlign=(short) (Hdr.Channels*Hdr.BitsPerSample / 8);
  Hdr.BytesPerSec=Hdr.SampleRate*Hdr.BlockAlign;
  Hdr.DataLength=NumSamps*Hdr.BlockAlign;
  Hdr.FileLength=sizeof(Hdr)+Hdr.DataLength-8;

  if ((fptr=fopen(fname,"wb"))==NULL) status=0;
  if (status && fwrite(&Hdr,sizeof(Hdr),1,fptr)!=1) status=0;
  if (status && fwrite(Buf,Hdr.DataLength,1,fptr)!=1) status=0;
  fclose(fptr);
  return(status);
}


long AudioC::ReadFile(char *fname)
{
FILE *fptr;
bool status;
WaveHeaderStruct thdr;
char *tbuf;

   // Open File
   fptr=fopen(fname,"rb");
   if (fptr!=NULL) status=true;
      else status=false;

   // Read Header
   if (status && (fread(&thdr,sizeof(thdr),1,fptr)!=1)) status=false;

   // We couldn't load the file
   if (!status)
   {
      return(0);
   }
   // Everything OK so far
   else
   {
      // Load Data
      // is there enough room in our buffer?
      if (MaxBytes<thdr.DataLength)
      {
         tbuf=Buf;
         Buf=(char *) realloc(Buf,thdr.DataLength);
         if (Buf!=NULL) MaxBytes=thdr.DataLength;
      }
      // did we get a good buffer?
      if (Buf==NULL)
      {
         status=false;
         Buf=tbuf;
      }
      if (status && (fread(Buf,thdr.DataLength,1,fptr)!=1)) status=false;

      if (status)
      {
         memcpy(&Hdr,&thdr,sizeof(WaveHeaderStruct));
         NumSamps=Hdr.DataLength/Hdr.BlockAlign;
      }
      // Close the File
      if (fptr!=NULL) fclose(fptr);
   }
   if (status) return(1); else return(0);
}

